Ext.data.JsonP.sol_common_ix_services_ParentDataCollector({"tagname":"class","name":"sol.common.ix.services.ParentDataCollector","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.common.ix.services.ParentDataCollector.js","href":"sol.common.ix.services.ParentDataCollector.html#sol-common-ix-services-ParentDataCollector"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"version":["1.1"],"eloix":true,"requires":["sol.common.Config","sol.common.JsonUtils","sol.common.ObjectFormatter","sol.common.SordUtils","sol.common.ix.DataCollectorBase","sol.common.ix.RfUtils","sol.common.ix.ServiceBase"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.DataCollectorBase","mixins":[],"uses":[],"members":[{"name":"allMapFields","tagname":"cfg","owner":"sol.common.ix.services.ParentDataCollector","id":"cfg-allMapFields","meta":{}},{"name":"formatter","tagname":"cfg","owner":"sol.common.ix.services.ParentDataCollector","id":"cfg-formatter","meta":{}},{"name":"hierarchicalIdentifier","tagname":"cfg","owner":"sol.common.ix.services.ParentDataCollector","id":"cfg-hierarchicalIdentifier","meta":{}},{"name":"mode","tagname":"cfg","owner":"sol.common.ix.services.ParentDataCollector","id":"cfg-mode","meta":{}},{"name":"objId","tagname":"cfg","owner":"sol.common.ix.services.ParentDataCollector","id":"cfg-objId","meta":{"required":true}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.common.ix.services.ParentDataCollector","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"sordKeys","tagname":"cfg","owner":"sol.common.ix.services.ParentDataCollector","id":"cfg-sordKeys","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"DEFAULT_VALUES","tagname":"property","owner":"sol.common.ix.services.ParentDataCollector","id":"property-DEFAULT_VALUES","meta":{"private":true}},{"name":"MODES","tagname":"property","owner":"sol.common.ix.services.ParentDataCollector","id":"property-MODES","meta":{"private":true}},{"name":"collectorVersion","tagname":"property","owner":"sol.common.ix.services.ParentDataCollector","id":"property-collectorVersion","meta":{"private":true}},{"name":"data","tagname":"property","owner":"sol.common.ix.ServiceBase","id":"property-data","meta":{}},{"name":"logger","tagname":"property","owner":"sol.common.ix.ServiceBase","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"checkMandatoryProperties","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-checkMandatoryProperties","meta":{"protected":true}},{"name":"collectHierarchy","tagname":"method","owner":"sol.common.ix.services.ParentDataCollector","id":"method-collectHierarchy","meta":{"private":true}},{"name":"containsClassName","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-containsClassName","meta":{}},{"name":"createTemplateSord","tagname":"method","owner":"sol.common.ix.services.ParentDataCollector","id":"method-createTemplateSord","meta":{"private":true}},{"name":"execute","tagname":"method","owner":"sol.common.ix.services.ParentDataCollector","id":"method-execute","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.DataCollectorBase","id":"method-initialize","meta":{"private":true}},{"name":"prefillMetadata","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-prefillMetadata","meta":{"protected":true}},{"name":"process","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-process","meta":{"abstract":true}},{"name":"RF_sol_common_service_ParentDataCollector","tagname":"method","owner":"sol.common.ix.services.ParentDataCollector","id":"static-method-RF_sol_common_service_ParentDataCollector","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.common.ix.services.ParentDataCollector","short_doc":"Collects all parent information from the hierarchy. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.ServiceBase","sol.common.ix.DataCollectorBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='docClass'>sol.common.ix.ServiceBase</a><div class='subclass '><a href='#!/api/sol.common.ix.DataCollectorBase' rel='sol.common.ix.DataCollectorBase' class='docClass'>sol.common.ix.DataCollectorBase</a><div class='subclass '><strong>sol.common.ix.services.ParentDataCollector</strong></div></div></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.Config' rel='sol.common.Config' class='docClass'>sol.common.Config</a></div><div class='dependency'><a href='#!/api/sol.common.JsonUtils' rel='sol.common.JsonUtils' class='docClass'>sol.common.JsonUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectFormatter' rel='sol.common.ObjectFormatter' class='docClass'>sol.common.ObjectFormatter</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.DataCollectorBase' rel='sol.common.ix.DataCollectorBase' class='docClass'>sol.common.ix.DataCollectorBase</a></div><div class='dependency'><a href='#!/api/sol.common.ix.RfUtils' rel='sol.common.ix.RfUtils' class='docClass'>sol.common.ix.RfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='docClass'>sol.common.ix.ServiceBase</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.ix.services.ParentDataCollector.html#sol-common-ix-services-ParentDataCollector' target='_blank'>sol.common.ix.services.ParentDataCollector.js</a></div></pre><div class='doc-contents'><p>Collects all parent information from the hierarchy.</p>\n\n<p>The hierarchy will be returned as a flat structure.</p>\n\n<p>The result hierarchy contains the following properties:</p>\n\n<ul>\n<li>sord: The selected element itself</li>\n<li>parent: The direct parent element</li>\n<li>SOL_TYPE: For each fount SOL_TYPE one property (see <a href=\"#!/api/sol.common.ix.services.ParentDataCollector-cfg-mode\" rel=\"sol.common.ix.services.ParentDataCollector-cfg-mode\" class=\"docClass\">mode</a>), could contain duplicates to 'parent' and 'sord'</li>\n</ul>\n\n\n<h1>Example</h1>\n\n<pre><code>var result = <a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>(\"RF_sol_common_service_ParentDataCollector\", {\n  objId: \"5690\",\n  formatter: \"<a href=\"#!/api/sol.common.ObjectFormatter.StatisticSord\" rel=\"sol.common.ObjectFormatter.StatisticSord\" class=\"docClass\">sol.common.ObjectFormatter.StatisticSord</a>\"\n});\n</code></pre>\n\n<h1>Result</h1>\n\n<pre><code>{\n  version: '1.00.000',\n  formatter: '<a href=\"#!/api/sol.common.ObjectFormatter.StatisticSord\" rel=\"sol.common.ObjectFormatter.StatisticSord\" class=\"docClass\">sol.common.ObjectFormatter.StatisticSord</a>',\n  sord: {\n    id: \"5690\",\n    name: 'Annual report',\n    O_INVOICE_DATE: '20160101'\n  },\n  parent: {\n    id: \"5669\",\n    name: '12 Public relations',\n    O_INVOICE_DATE: '20151202'\n  },\n  FILE: {\n    id: \"5669\",\n    name: '12 Public relations',\n    O_INVOICE_DATE: '20151202'\n  },\n  ...\n}\n</code></pre>\n      <p class='version-tag'>Version: <b>1.1</b></p>\n</div><div class='members'><div class='members-section'><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Required config options</h3><div id='cfg-objId' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ParentDataCollector'>sol.common.ix.services.ParentDataCollector</span><br/><a href='source/sol.common.ix.services.ParentDataCollector.html#sol-common-ix-services-ParentDataCollector-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ParentDataCollector-cfg-objId' class='name expandable'>objId</a> : String<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'><p>id of the parent element (guid, objId or archivepath)</p>\n</div><div class='long'><p>id of the parent element (guid, objId or archivepath)</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.ServiceBase-cfg-objId\" rel=\"sol.common.ix.ServiceBase-cfg-objId\" class=\"docClass\">sol.common.ix.ServiceBase.objId</a></p></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Optional config options</h3><div id='cfg-allMapFields' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ParentDataCollector'>sol.common.ix.services.ParentDataCollector</span><br/><a href='source/sol.common.ix.services.ParentDataCollector.html#sol-common-ix-services-ParentDataCollector-cfg-allMapFields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ParentDataCollector-cfg-allMapFields' class='name expandable'>allMapFields</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'><p>The data objects will contain all map fields.</p>\n</div><div class='long'><p>The data objects will contain all map fields.</p>\n</div></div></div><div id='cfg-formatter' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ParentDataCollector'>sol.common.ix.services.ParentDataCollector</span><br/><a href='source/sol.common.ix.services.ParentDataCollector.html#sol-common-ix-services-ParentDataCollector-cfg-formatter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ParentDataCollector-cfg-formatter' class='name expandable'>formatter</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Sord object formatter implementation. ...</div><div class='long'><p>Sord object formatter implementation.</p>\n\n<p>e.g. <code><a href=\"#!/api/sol.common.ObjectFormatter.StatisticSord\" rel=\"sol.common.ObjectFormatter.StatisticSord\" class=\"docClass\">sol.common.ObjectFormatter.StatisticSord</a></code> or <code><a href=\"#!/api/sol.common.ObjectFormatter.TemplateSord\" rel=\"sol.common.ObjectFormatter.TemplateSord\" class=\"docClass\">sol.common.ObjectFormatter.TemplateSord</a></code></p>\n<p>Defaults to: <code>&quot;sol.common.ObjectFormatter.StatisticSord&quot;</code></p></div></div></div><div id='cfg-hierarchicalIdentifier' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ParentDataCollector'>sol.common.ix.services.ParentDataCollector</span><br/><a href='source/sol.common.ix.services.ParentDataCollector.html#sol-common-ix-services-ParentDataCollector-cfg-hierarchicalIdentifier' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ParentDataCollector-cfg-hierarchicalIdentifier' class='name expandable'>hierarchicalIdentifier</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>The value from this field will be used to collect the hierarchy ...</div><div class='long'><p>The value from this field will be used to collect the hierarchy</p>\n<p>Defaults to: <code>&quot;SOL_TYPE&quot;</code></p></div></div></div><div id='cfg-mode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ParentDataCollector'>sol.common.ix.services.ParentDataCollector</span><br/><a href='source/sol.common.ix.services.ParentDataCollector.html#sol-common-ix-services-ParentDataCollector-cfg-mode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ParentDataCollector-cfg-mode' class='name expandable'>mode</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>The mode defines, which object from the hierarchy will be send with the result. ...</div><div class='long'><p>The mode defines, which object from the hierarchy will be send with the result.</p>\n\n<ul>\n<li>\"FIRST_WINS\": the first hit (upwards) in the hierarchy for each type wins</li>\n<li>\"LAST_WINS\": the last hit (upwards) in the hierarchy for each type wins</li>\n<li>\"ALL\": collects an array of the specific type (not implemented yet)</li>\n</ul>\n\n<p>Defaults to: <code>&quot;FIRST_WINS&quot;</code></p></div></div></div><div id='cfg-requiredConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ParentDataCollector'>sol.common.ix.services.ParentDataCollector</span><br/><a href='source/sol.common.ix.services.ParentDataCollector.html#sol-common-ix-services-ParentDataCollector-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ParentDataCollector-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n<p>Defaults to: <code>[&quot;objId&quot;]</code></p><p>Overrides: <a href=\"#!/api/sol.Base-cfg-requiredConfig\" rel=\"sol.Base-cfg-requiredConfig\" class=\"docClass\">sol.Base.requiredConfig</a></p></div></div></div><div id='cfg-sordKeys' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ParentDataCollector'>sol.common.ix.services.ParentDataCollector</span><br/><a href='source/sol.common.ix.services.ParentDataCollector.html#sol-common-ix-services-ParentDataCollector-cfg-sordKeys' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ParentDataCollector-cfg-sordKeys' class='name expandable'>sordKeys</a> : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>The data objects will contain this keys from the sord. ...</div><div class='long'><p>The data objects will contain this keys from the sord.\nBy default the following keys will be returned: ['id', 'guid', 'maskName', 'name', 'desc', 'IDateIso', 'XDateIso', 'ownerName']</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-DEFAULT_VALUES' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ParentDataCollector'>sol.common.ix.services.ParentDataCollector</span><br/><a href='source/sol.common.ix.services.ParentDataCollector.html#sol-common-ix-services-ParentDataCollector-property-DEFAULT_VALUES' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ParentDataCollector-property-DEFAULT_VALUES' class='name expandable'>DEFAULT_VALUES</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{hierarchicalIdentifier: &quot;SOL_TYPE&quot;, mode: &quot;FIRST_WINS&quot;, formatter: &quot;sol.common.ObjectFormatter.TemplateSord&quot;, sordKeys: [&quot;id&quot;, &quot;guid&quot;, &quot;maskName&quot;, &quot;name&quot;, &quot;desc&quot;, &quot;IDateIso&quot;, &quot;XDateIso&quot;, &quot;ownerName&quot;], allMapFields: false}</code></p></div></div></div><div id='property-MODES' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ParentDataCollector'>sol.common.ix.services.ParentDataCollector</span><br/><a href='source/sol.common.ix.services.ParentDataCollector.html#sol-common-ix-services-ParentDataCollector-property-MODES' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ParentDataCollector-property-MODES' class='name expandable'>MODES</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{FIRST_WINS: &quot;FIRST_WINS&quot;, LAST_WINS: &quot;LAST_WINS&quot;, ALL: &quot;ALL&quot;}</code></p></div></div></div><div id='property-collectorVersion' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ParentDataCollector'>sol.common.ix.services.ParentDataCollector</span><br/><a href='source/sol.common.ix.services.ParentDataCollector.html#sol-common-ix-services-ParentDataCollector-property-collectorVersion' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ParentDataCollector-property-collectorVersion' class='name expandable'>collectorVersion</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;1.01.000&quot;</code></p></div></div></div><div id='property-data' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-property-data' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-property-data' class='name expandable'>data</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional)\nHas to be in a specific form (see <a href=\"#!/api/sol.common.SordUtils-method-updateSord\" rel=\"sol.common.SordUtils-method-updateSord\" class=\"docClass\">sol.common.SordUtils.updateSord</a>).</p>\n</div><div class='long'><p>(optional)\nHas to be in a specific form (see <a href=\"#!/api/sol.common.SordUtils-method-updateSord\" rel=\"sol.common.SordUtils-method-updateSord\" class=\"docClass\">sol.common.SordUtils.updateSord</a>).</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the service</p>\n</div><div class='long'><p>The logger for the service</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-checkMandatoryProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-checkMandatoryProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-checkMandatoryProperties' class='name expandable'>checkMandatoryProperties</a>( <span class='pre'></span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Checks if all mandatory properties have been set. ...</div><div class='long'><p>Checks if all mandatory properties have been set.</p>\n</div></div></div><div id='method-collectHierarchy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ParentDataCollector'>sol.common.ix.services.ParentDataCollector</span><br/><a href='source/sol.common.ix.services.ParentDataCollector.html#sol-common-ix-services-ParentDataCollector-method-collectHierarchy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ParentDataCollector-method-collectHierarchy' class='name expandable'>collectHierarchy</a>( <span class='pre'>sord, dataObj</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>dataObj</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-containsClassName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-containsClassName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-containsClassName' class='name expandable'>containsClassName</a>( <span class='pre'>classNames</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether an array contains the class name ...</div><div class='long'><p>Checks wether an array contains the class name</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>classNames</span> : Array<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createTemplateSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ParentDataCollector'>sol.common.ix.services.ParentDataCollector</span><br/><a href='source/sol.common.ix.services.ParentDataCollector.html#sol-common-ix-services-ParentDataCollector-method-createTemplateSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ParentDataCollector-method-createTemplateSord' class='name expandable'>createTemplateSord</a>( <span class='pre'>sord</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-execute' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ParentDataCollector'>sol.common.ix.services.ParentDataCollector</span><br/><a href='source/sol.common.ix.services.ParentDataCollector.html#sol-common-ix-services-ParentDataCollector-method-execute' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ParentDataCollector-method-execute' class='name expandable'>execute</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Starts the collection of the desired data ...</div><div class='long'><p>Starts the collection of the desired data</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.DataCollectorBase-method-execute\" rel=\"sol.common.ix.DataCollectorBase-method-execute\" class=\"docClass\">sol.common.ix.DataCollectorBase.execute</a></p></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.DataCollectorBase' rel='sol.common.ix.DataCollectorBase' class='defined-in docClass'>sol.common.ix.DataCollectorBase</a><br/><a href='source/lib_sol.common.ix.DataCollectorBase.html#sol-common-ix-DataCollectorBase-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DataCollectorBase-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.ServiceBase-method-initialize\" rel=\"sol.common.ix.ServiceBase-method-initialize\" class=\"docClass\">sol.common.ix.ServiceBase.initialize</a></p></div></div></div><div id='method-prefillMetadata' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-prefillMetadata' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-prefillMetadata' class='name expandable'>prefillMetadata</a>( <span class='pre'>objId</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Initializes the metadata of an element (defined by objId) from the internal data object. ...</div><div class='long'><p>Initializes the metadata of an element (defined by <code>objId</code>) from the internal <code>data</code> object.</p>\n\n<p>The <code>data</code> property has to be in a specific <a href=\"#!/api/sol.common.ix.ServiceBase-property-data\" rel=\"sol.common.ix.ServiceBase-property-data\" class=\"docClass\">form</a>.\nIf there is no data object no prefilling will be performed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-process' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-process' class='name expandable'>process</a>( <span class='pre'></span> )<span class=\"signature\"><span class='abstract' >abstract</span></span></div><div class='description'><div class='short'>Implementation of services' process. ...</div><div class='long'><p>Implementation of services' process. This function must be implemented by the child class and should contain the logic of the function module.</p>\n</div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_sol_common_service_ParentDataCollector' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ParentDataCollector'>sol.common.ix.services.ParentDataCollector</span><br/><a href='source/sol.common.ix.services.ParentDataCollector.html#sol-common-ix-services-ParentDataCollector-static-method-RF_sol_common_service_ParentDataCollector' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ParentDataCollector-static-method-RF_sol_common_service_ParentDataCollector' class='name expandable'>RF_sol_common_service_ParentDataCollector</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});